<?php

	class syra_reseller_api {
		private $reseller_api_soap_client;

		function __construct($params) {
						
			//set the login headers
			$authenticate = array();
			$authenticate['AuthenticateRequest'] = array();
			$authenticate['AuthenticateRequest']['ResellerID'] = $params["ResellerID"];
			$authenticate['AuthenticateRequest']['APIKey'] = $params['APIKey'];

			//convert $authenticate to a soap variable
			$authenticate['AuthenticateRequest'] = new SoapVar($authenticate['AuthenticateRequest'], SOAP_ENC_OBJECT);
			$authenticate = new SoapVar($authenticate, SOAP_ENC_OBJECT);

			if($params['TestMode']=="on"){
				$wsdlurl = 'http://soap-test.secureapi.com.au/wsdl/API-1.0.wsdl';
				$soapurl = 'http://soap-test.secureapi.com.au/API-1.0';
			} else {
				$wsdlurl = "http://soap.secureapi.com.au/wsdl/API-1.0.wsdl";
				$soapurl = 'http://soap.secureapi.com.au/API-1.0';
			}

			$header = new SoapHeader($soapurl, 'Authenticate', $authenticate, false);

			$this->reseller_api_soap_client = new SoapClient($wsdlurl, array('soap_version' => SOAP_1_2, 'cache_wsdl' => WSDL_CACHE_NONE));
			$this->reseller_api_soap_client->__setSoapHeaders(array($header));
		}

		function call($method, $data = null) {
			$prepared_data = $data != null ? array($data) : array();

			try {
				$response = $this->reseller_api_soap_client->__soapCall($method, $prepared_data);
			} catch (SoapFault $response) { }

			return $response;
		}
	}

?>